<?php

namespace DevDasher\XShare2Bot\Middlewares;

use SergiX44\Nutgram\Middleware\Link;
use SergiX44\Nutgram\Nutgram;
use SergiX44\Nutgram\Telegram\Properties\UpdateType;

class AllowedUpdateTypesMiddleware
{
    public function __invoke(Nutgram $bot, Link $next)
    {
        $allowedUpdates = config('bot.allowed_updates');
        $updateType = $bot->update()->getType();
        if (!in_array($updateType, $allowedUpdates)) {
            return;
        }
        $next($bot);
    }
}