<?php
$config = require_once 'config.php';

if (!isset($config['TELEGRAM_BOT_TOKEN']) || !isset($config['TELEGRAM_CHAT_IDS']) || !is_array($config['TELEGRAM_CHAT_IDS'])) {
    die("Bot token or chat IDs are missing or invalid.");
}

$botToken = $config['TELEGRAM_BOT_TOKEN'];
$chatIds = $config['TELEGRAM_CHAT_IDS']; // آرایه‌ای از چت آیدی‌ها

$servers = [
    "panel.irnservers.top" => "Virtualizor",
    "aa.i.irnservers.top" => "Panel Me",
    "fast.turb0.site" => "IR - US JAV",
    "fast.antiking.fun" => "IR - FNLD JAV",
    "absx.site" => "IR - GR JAV",
    "m0on.youns.site" => "IR - YOUNS",
    "curt1.mibilenoori.fun" => "IR - NOORI",
    "c.ag.irnservers.top" => "IR - AGH",
    "panl.ag3.irnservers.top" => "IR - AGH 3",
    "138.199.145.10" => "GR - JAV",
    "5.161.111.58" => "US - JAV",
    "37.27.194.126" => "FLND - JAV",
    "49.12.216.1" => "GR - ME",
    "138.199.158.129" => "GR - YOUNS",
    "188.245.93.252" => "GR - PANEL ALL ",
];

function checkServerStatus($server) {
    $pingResult = shell_exec("ping -c 4 $server");
    return strpos($pingResult, '4 packets transmitted, 4 received') !== false;
}

function sendTelegramMessage($botToken, $chatIds, $message) {
    foreach ($chatIds as $chatId) {
        $url = "https://api.telegram.org/bot$botToken/sendMessage";
        $data = [
            'chat_id' => $chatId,
            'text' => $message,
            'parse_mode' => 'Markdown'
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);

        curl_exec($ch); // بدون ذخیره لاگ
        
        curl_close($ch);
    }
}

function checkServerMultipleTimes($server, $retries = 4) {
    $attempts = 0;
    while ($attempts < $retries) {
        if (checkServerStatus($server)) {
            return true; // اگر سرور آنلاین بود، بازگشت به true
        }
        $attempts++;
        sleep(3); // کمی زمان صبر میکنیم (مثلاً 3 ثانیه) قبل از چک کردن دوباره
    }
    return false; // اگر هیچکدام از چک‌ها آنلاین نباشند
}

$update = json_decode(file_get_contents("php://input"), true);
$isWebhook = isset($update['message']);

if ($isWebhook) {
    $userId = $update['message']['from']['id'];
    if (!in_array($userId, $chatIds)) {
        exit();
    }
}

foreach ($servers as $server => $name) {
    $ip = filter_var($server, FILTER_VALIDATE_IP) ? $server : gethostbyname($server);
    $isOnline = checkServerStatus($server);
    
    // اگر سرور آنلاین نیست، بررسی دوباره انجام می‌دهیم
    if (!$isOnline) {
        $isOnline = checkServerMultipleTimes($server);
    }

    if ($isWebhook || !$isOnline) {
        $statusMessage = $isOnline 
            ? "🟢 ***$name*** ( `{$server}` -  `{$ip}`)  ✅" 
            : "🔴 ***$name*** ( `{$server}` -  `{$ip}`)  ❌";
        
        sendTelegramMessage($botToken, $chatIds, $statusMessage);
    }
}
?>
