<?php declare(strict_types = 1);
//==================== Start Bot ===========Mahdi===============
/*
 * Basic MadelineProto-v7 Robot : Tabchi XPlus
 * Date : 2022/08/25
 * Author : @Mahdi_a_8
 */
//==================== Start Bot ==========================
date_default_timezone_set('Asia/Tehran');
//==================== Use in The Bot =====================
use Amp\Promise;
use danog\MadelineProto\Logger;
use danog\MadelineProto\Settings;
use danog\Loop\Generic\GenericLoop;
use danog\MadelineProto\EventHandler as BaseEventHandler;
//==================== In Put File ========================
if (!is_file('madeline.phar')) {
copy('https://github.com/danog/MadelineProto/releases/download/7.0.152/madeline.phar', 'madeline.phar');
}
include 'madeline.phar';

if(!is_dir("Data")) mkdir("Data");
//==================== Start Class Bot ==========================
class EventHandler extends BaseEventHandler
{
const ADMIN = 'Mahdi_a_8';  // Your Username

protected array $genLoops = [];

public function getReportPeers(): array
{
return [self::ADMIN];
}
public function onStart(): void
{
$eh             = $this;
$this->genLoops = [];
$this->genLoops []= new GenericLoop(
function () use ($eh) {
$eh->logger("The good ol' useless loop is here! :D", Logger::LEVEL_VERBOSE);
// Repeat every 30 seconds.
return 30_000;
},
'UselessLoop'
);
}
public function onUpdateNewChannelMessage(array $update)
{
return $this->onUpdateNewMessage($update);
}
public function onUpdateNewMessage(array $update)
{
// Skip `service` and `empty` messages.
if ($update['message']['_'] !== 'message' and time() - $update['message']['date'] > 2) {
return;
}
// NOTE: `$Message` causes other variables to evaluate faster!
//==================== Variables Bot ==========================
$Message = $update['message'];
$MsgID   = $Message['id']      ?? null;
$text    = $Message['message'] ?? '';
$UserID  = $Message['from_id']['user_id']          ?? null;
$replyTo = $Message['reply_to']['reply_to_msg_id'] ?? null;
$Info    = yield $this->getInfo($update);
$Type    = $Info['type'];
$ChatID  = $Info['bot_api_id'];
$Admin   = '[*[ADMIN]*]';
$Date    = date("Y/m/d");
$Time    = date("H:i:s");
//==================== functions Bot =========================
$respond = function (string $response, ?string $parseMode='Markdown')
use ($update, $MsgID): Promise {
return $this->respond($update, $response, $MsgID, $parseMode);
};
//==================== Check Admin Bot =======================
if($UserID == $Admin){
if ($text == "ping" or $text == "ربات" or $text == "الو" or $text == "عشقم" or $text == "." or $text == "+") {
$start = microtime(true);
$sent  = yield $respond('**جونم قربان درخدمتم ؟!**');
$end   = microtime(true);
$ping  = round(($end - $start) * 1000, 3);
yield  $this->sleep(2);
return $this->editMsg($ChatID, $this->getSentId($sent), "`Ping : $ping Ms`");
}
//==================== HelpAdmin ======================
elseif ($text == "Restart" or $text == "restart" or $text == "Res" or $text == "res" or $text == "ریستارت" or $text == "ریس") {
if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') {
return $respond("**Error:**\n`Restart is not !`");
}
yield $respond("» ربات برای دریافت آپدیت ها مجدد راه اندازی شد !
» لطفا پس از 5 دقیقه دستور ارسال کنید !");
$this->restart();
}
elseif($text == "/exports"){
$ids = '';
foreach($this->getDialogs() as $m){
if(isset($m['user_id'])){
$ids .= "{$m['user_id']}\n";}
file_put_contents('Data/Member.txt',$ids);
yield $respond("تمام !");
}
}

}

}
//==================== functions Bot ====================
protected function respond(array $update, string $text, ?int $messageId=null, ?string $parseMode='Markdown'): Promise
{
if ($update['message']['out'] ?? false) {
return $this->editMsg($update, $messageId, $text, $parseMode);
}
return $this->sendMsg($update, $text, $parseMode, $messageId);
}
protected function sendMsg($Chat_ID, string $text, ?string $parseMode='Markdown', ?int $replyTo=null): array
{
return $this->messages->sendMessage([
'peer'            => $Chat_ID,
'message'         => $text,
'parse_mode'      => $parseMode,
'reply_to_msg_id' => $replyTo,
]);
}
protected function editMsg($Chat_ID, int $messageId, string $text, ?string $parseMode='Markdown'): array
{
return $this->messages->editMessage([
'id'         => $messageId,
'peer'       => $Chat_ID,
'message'    => $text,
'parse_mode' => $parseMode,
]);
}
public function getSentId(array $response): ?int
{
if (isset($response['id'])) {
return $response['id'];
}
if (isset($response['updates'])) {
foreach ($response['updates'] as $update) {
switch ($update['_']) {
case 'updateMessageID':
return $update['id'];
case 'updateNewMessage':
case 'updateEditMessage':
case 'updateNewChannelMessage':
case 'updateEditChannelMessage':
return $update['message']['id'];
}
}
}
$this->logger("id of the sent message not found", Logger::LEVEL_ERROR);
return null;
}
}
//==================== functions Bot ====================
$settings = new Settings;
$settings->getLogger()->setLevel(Logger::LEVEL_ULTRA_VERBOSE);
$settings->getPeer()
->setFullFetch(FALSE)
->setCacheAllPeersOnStartup(FALSE);
$settings->getAppInfo()
->setApiId(12765878)
->setApiHash("a774388249bed1b1793f4aa0205ca271");
//==================== functions Bot ====================
is_dir('Session') || mkdir('Session');
EventHandler::StartAndLoopBot('Session/s.f', '[*[TOKEN]*]' , $settings);